<?php
/* --------------------------------------------------------------
 UserConfigurationLoader.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Admin\UserConfiguration\Interfaces\CurrentUserConfigurationService;
use Gambio\Core\Language\TextManager;
use Smarty;

/**
 * Class UserConfigurationLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class UserConfigurationLoader implements LoaderInterface
{
    /**
     * @var CurrentUserConfigurationService
     */
    private $userConfigurationService;
    
    /**
     * @var TextManager
     */
    private $textManager;
    
    /**
     * @var int
     */
    private $languageId;
    
    
    /**
     * UserConfigurationLoader constructor.
     *
     * @param CurrentUserConfigurationService $userConfigurationService
     * @param TextManager                     $textManager
     * @param UserPreferences                 $userPreferences
     */
    public function __construct(
        CurrentUserConfigurationService $userConfigurationService,
        TextManager $textManager,
        UserPreferences $userPreferences
    ) {
        $this->userConfigurationService = $userConfigurationService;
        $this->textManager              = $textManager;
        $this->languageId               = $userPreferences->languageId();
    }
    
    
    /**
     * @inheritDoc
     */
    public function load(Smarty $smarty): void
    {
        $smarty->assign('menu_visibility', $this->userConfigurationService->getValue('menuVisibility', 'expand'));
        
        $recentSearchArea = $this->userConfigurationService->getValue('recent_search_area');
        $phrase           = $recentSearchArea ? "admin_search_{$recentSearchArea}" : 'admin_search_categories';
        $section          = 'admin_labels';
        
        $smarty->assign('recent_search_area', $recentSearchArea);
        $smarty->assign('placeholder', $this->textManager->getPhraseText($phrase, $section, $this->languageId));
    }
}